IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'Notificaciones' AND TABLE_SCHEMA = 'dbo') 
BEGIN
    CREATE TABLE Notificaciones(
		Id_Notificacion INT IDENTITY(1,1) NOT NULL,
		Titulo VARCHAR (255) NOT NULL,
		Descripcion [text] NULL,
		Html TEXT NULL,
		Link VARCHAR(255) NULL,
		Fecha_Creacion DATETIME NULL,
		Nueva_Ventana TINYINT NULL,
		Id_Usuario SMALLINT NULL,
		Is_Personalizado TINYINT NOT NULL,
	PRIMARY KEY CLUSTERED 
	(
		Id_Notificacion ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

	ALTER TABLE [dbo].[Notificaciones] ADD  DEFAULT (getdate()) FOR [Fecha_Creacion]
	ALTER TABLE [dbo].[Notificaciones] ADD  DEFAULT ((0)) FOR [Nueva_Ventana]
	ALTER TABLE [dbo].[Notificaciones] ADD  DEFAULT ((0)) FOR [Is_Personalizado]
END